<?php

namespace App\Http\Requests\Company;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class FactoryInformationRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
            }
            case 'PATCH':
            {
                $id=$this->request->get('id');
                return [
                    'factory_location' => 'nullable|string|max:255',
                    'factory_total_area' => 'nullable|string|max:255',
                    'no_production_staff' => 'nullable|string|max:255',
                    'no_qc_staff' => 'nullable|string|max:255',
                    'no_rd_staff' => 'nullable|string|max:255',
                    'no_production_lines' => 'nullable|integer|min:0',
                    'annual_output' => 'nullable|string|max:255',
                    'average_lead_time' => 'nullable|string|max:255',
                    'gallery.*' => 'nullable|file|mimes:jpeg,png,webp|max:5120',
                    'video' => 'nullable|file|mimes:mp4|max:10240',
                    'video_url' => 'nullable|url|max:255',
                ];
            }
            default:
                break;
        }
    }
}
