<?php

namespace App\Http\Requests\Company;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class OfficeInformationRequest extends FormRequest
{
    public function authorize()
    {
        return Auth::check();
    }

    public function rules()
    {
        switch ($this->method()) {
            case 'POST':{
                return [
                    'country_id' => ['required', 'exists:countries,id'],
                    'state_id' => ['required', 'exists:states,id'],
                    'city_id' => ['required', 'exists:cities,id'],
                    'street' => ['required', 'string', 'max:255'],
                    'zip_code' => ['required', 'string', 'max:20'],
                    'time_zone' => ['required', 'string', 'max:50'],
                ];
            }
            case 'PATCH': {
                return [
                    'country_id' => ['required', 'exists:countries,id'],
                    'state_id' => ['required', 'exists:states,id'],
                    'city_id' => ['required', 'exists:cities,id'],
                    'street' => ['required', 'string', 'max:255'],
                    'zip_code' => ['required', 'string', 'max:20'],
                    'time_zone' => ['required', 'string', 'max:50'],
                ];
            }
            default: {
                return [];
            }
        }
    }
}