<?php

namespace App\Http\Requests\Land;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class LandingRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                $type=$this->request->get('type');
                if($type == 'landing')
                {
                    return [
                        'title' => 'required|max:240',
                        'title_footer' => 'required|max:100',
                        'slug' => 'required|max:100|unique:landings',
                        'status' => 'required',
                    ];
                }
                else
                {
                    return [
                        'title' => 'required|max:240',
                        'status' => 'required',
                        'text' => 'nullable',
                        'photo' => "nullable|image|mimes:jpeg,jpg,webp|max:512",
                    ];
                }
            }
            case 'PATCH':
            {
                $id=$this->request->get('id');
                $type=$this->request->get('type');
                if($type == 'landing')
                {
                    return [
                        'title' => 'required|max:240',
                        'title_footer' => 'required|max:100',
                        'slug' => 'required|max:100|unique:landings,slug,'.$id,
                        'status' => 'required',
                    ];
                }
                else
                {
                    return [
                        'title' => 'required|max:240',
                        'status' => 'required',
                        'text' => 'nullable',
                        'photo' => "nullable|image|mimes:jpeg,jpg,webp|max:512",
                    ];
                }
            }
            default:
                break;
        }
    }
}
