<?php

namespace App\Http\Requests\Other;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class LearningRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'text' => 'required',
                    'slug' => 'required|max:300',
                    'photo' => "required|image|mimes:jpeg,jpg,png,webp|max:512",
                    'video' => "nullable|mimes:mp4|max:30720",
                    'link' => 'nullable|url',
                ];
            }
            case 'PATCH':
            {
                $id=$this->request->get('id');
                return [
                    'text' => 'required',
                    'slug' => 'required|max:300',
                    'photo' => "nullable|image|mimes:jpeg,jpg,png,webp|max:512",
                    'video' => "nullable|mimes:mp4|max:30720",
                    'link' => 'nullable|url',
                ];
            }
            default:
                break;
        }
    }
}
