<?php

namespace App\Http\Requests\Other;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class SourcingMagazineRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'cat_id' => 'required',
                    'title' => 'required|max:75',
                    'issue_date' => 'required|max:100',
                    'includes' => 'required|max:3000',
                    'text' => 'required|max:3000',
                    'photo' => "required|image|mimes:jpeg,jpg,png,webp|max:512",
                    'pdf' => "required|mimes:pdf|max:51200",
                ];
            }
            case 'PATCH':
            {
                $id=$this->request->get('id');
                return [
                    'cat_id' => 'required',
                    'title' => 'required|max:75',
                    'issue_date' => 'required|max:100',
                    'includes' => 'required|max:3000',
                    'text' => 'required|max:3000',
                    'photo' => "nullable|image|mimes:jpeg,jpg,png,webp|max:512",
                    'pdf' => "nullable|mimes:pdf|max:51200",
                ];
            }
            default:
                break;
        }
    }
}
