<?php

namespace App\Http\Requests\Product;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class ProductRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'category_id' => 'required',
                    'title' => 'required|max:175',
//                    'slug' => 'required|max:255|unique:products,slug',
                    'text' => 'required',
                    'unit' => 'required|max:100',
                    'photo' => "required|image|mimes:jpeg,jpg,png,webp|max:512",
                    'video' => "nullable|mimes:mp4,mov|max:10240",
                    'icon' => "nullable|image|mimes:png,webp|max:256",
                ];
            }
            case 'PATCH':
            {
                $id=$this->request->get('id');
                return [
                    'category_id' => 'required',
                    'title' => 'required|max:175',
//                    'slug' => 'required|max:255|unique:products,slug,' . $id,
                    'text' => 'required',
                    'unit' => 'required|max:100',
                    'photo' => "nullable|image|mimes:jpeg,jpg,png,webp|max:512",
                    'video' => "nullable|mimes:mp4,mov|max:10240",
                    'icon' => "nullable|image|mimes:png,webp|max:256",
                ];
            }
            default:
                break;
        }
    }
}
