<?php

namespace App\Http\Requests\Product\Supplier;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class CategoryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'parent_id1' => 'required',
                    'parent_id2' => 'required',
                    'parent_id' => 'required',
                    'title' => 'required|max:255',
                ];
            }
            case 'PATCH':
            {
                $id = $this->request->get('id');
                return [
                    'parent_id1' => 'required',
                    'parent_id2' => 'required',
                    'parent_id' => 'required',
                    'title' => 'required|max:255',
                ];
            }
            default:
                break;
        }
    }
}
