<?php

namespace App\Http\Requests\Setting;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class AboutRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {

            }
            case 'PATCH':
            {
                $id=$this->request->get('id');
                return [
                    'title' => 'required|max:240',
                    'text' => 'required',
                    'pic' => "nullable|image|mimes:jpeg,jpg,webp|max:512",
                ];
            }
            default:
                break;
        }
    }
}
