<?php

namespace App\Http\Requests\Setting;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class SiteWordRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'slug' => 'required|max:100|unique:site_words',
                    'word' => 'required',
                ];
            }
            case 'PATCH':
            {
                $id=$this->request->get('id');
                return [
                    'slug' => 'required|max:100|unique:site_words,slug,'.$id,
                    'word' => 'required',
                ];
            }
            default:
                break;
        }
    }
}
