<?php

namespace App\Http\Requests\User;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class UserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'username' => 'required|min:4|max:20|unique:users',
                    'password' => 'required|min:6|confirmed',
                    'name' => 'required|max:75',
                    'role_name' => 'required',
                    'photo' => "nullable|image|mimes:jpeg,jpg,png,webp|max:2048",
                ];
            }
            case 'PATCH':
            {
                $id=$this->request->get('id');
                return [
                    'username' => 'required|min:4|max:20|unique:users,username,'.$id,
                    'password' => 'nullable|min:6|confirmed',
                    'name' => 'required|max:75',
                    'role_name' => 'required',
                    'photo' => "nullable|image|mimes:jpeg,jpg,png,webp|max:2048"
                ];
            }
            default:
                break;
        }
    }
}
