<?php

namespace App\Livewire\Components;

use Livewire\Attributes\Layout;
use Livewire\Component;

class Editor extends Component
{
    public $value = '';
    public $field = '';
    public $required = false;
    public $immediateUpdate = false;
    public $label = '';
    public $disabled = false;
    public $uniqueKey;
    public $filebrowserImageBrowseUrl;
    public $filebrowserImageUploadUrl;
    public $filebrowserBrowseUrl;
    public $filebrowserUploadUrl;
    public $language = 'en';
    public $contentsLangDirection = 'ltr';
    public $height = '200px';
    public $toolbar = 'full';

    public function mount(
        $value = '',
        $field = '',
        $required = false,
        $immediateUpdate = false,
        $label = '',
        $disabled = false,
        $uniqueKey = null,
        $filebrowserImageBrowseUrl = '',
        $filebrowserImageUploadUrl = '',
        $filebrowserBrowseUrl = '',
        $filebrowserUploadUrl = '',
        $language = 'en',
        $contentsLangDirection = 'ltr',
        $height = '200px',
        $toolbar = 'full'
    ) {
        try {
            $this->value = $value;
            $this->field = $field;
            $this->required = $required;
            $this->immediateUpdate = $immediateUpdate;
            $this->label = $label;
            $this->disabled = $disabled;
            $this->uniqueKey = $uniqueKey ?? uniqid('ckeditor_');
            $this->filebrowserImageBrowseUrl = $filebrowserImageBrowseUrl ?: url('filemanager?type=Images');
            $this->filebrowserImageUploadUrl = $filebrowserImageUploadUrl ?: url('filemanager/upload?type=Images&_token=');
            $this->filebrowserBrowseUrl = $filebrowserBrowseUrl ?: url('filemanager?type=Files');
            $this->filebrowserUploadUrl = $filebrowserUploadUrl ?: url('filemanager/upload?type=Files&_token=');
            $this->language = $language;
            $this->contentsLangDirection = $contentsLangDirection;
            $this->height = $height;
            $this->toolbar = $toolbar;
        } catch (\Exception $e) {
            $this->dispatch('errorShow', icon: 'error', title: 'Error', text: $e->getMessage());
        }
    }

    #[Layout('components.layouts.app', [
        'assets' => ['editor'],
        'theme' => '7'
    ])]
    public function render()
    {
        return view('livewire.components.editor');
    }
}