<?php

namespace App\Livewire\Dashboard\Company\CompanyCertificate;

use Illuminate\Support\Facades\DB;
use Livewire\Attributes\Layout;
use Livewire\Attributes\On;
use Livewire\Component;
use App\Models\CompanyCertificate;

class Manage extends Component
{
    public $items;
    public $dashboardCode;
    public $sort = [];

    public function mount($dashboard_code)
    {
        $this->items = CompanyCertificate::where('dashboard_code', $dashboard_code)->orderBy('sort')->get();
        $this->dashboardCode = $dashboard_code;
        foreach ($this->items as $item) {
            $this->sort[$item->id] = $item->sort;
        }
    }

    #[On('sortUpdate')]
    public function sortUpdate($id,$sort)
    {
        $certificate = CompanyCertificate::find($id);
        $this->authorize('update', $certificate);
        if ($certificate) {
            $certificate->sort = $sort;
            $certificate->save();
            $this->dispatch('tableRender');
            $this->dispatch('alert', icon: 'success', title: 'Updated');
        }
    }

    #[On('remove')]
    public function remove($id)
    {
        $item = CompanyCertificate::findOrFail($id);
        try {
            $this->authorize('delete', $item);
            $item->delete();
            $this->items = CompanyCertificate::where('dashboard_code', $this->dashboardCode)->orderBy('sort')->get();
            $this->dispatch('tableRender');
            $this->dispatch('insert', icon: 'info', title: 'Deleted', text: 'Certificate deleted successfully.');
        } catch (\Exception $e) {
            $this->dispatch('insert', icon: 'error', title: 'Error', text: 'Failed to delete certificate.');
        }
    }

    #[On('itemRender')]
    public function tableRender()
    {
        $this->items = CompanyCertificate::where('dashboard_code', $this->dashboardCode)->orderBy('sort')->get();
        $this->dispatch('tableRender');
    }

    #[Layout('components.layouts.app', [
        'assets' => ['table','editor'],
        'theme' => '7'
    ])]
    public function render()
    {
        return view('livewire.dashboard.company.company-certificate.manage', [
            'title' => 'Manage Company Certificates',
            'page_title' => ['Company', 'Company Certificates'],
        ]);
    }
}