<?php

namespace App\Livewire\Dashboard\Company\CompanyFaq;

use App\Http\Traits\StatusTrait;
use Illuminate\Support\Facades\DB;
use Livewire\Component;
use App\Models\CompanyFaq;

class Create extends Component
{
    use StatusTrait;
    public $dashboardCode;
    public $sort = [];
    public $translatableFields = [
        'question',
        'answer',
        'status',
    ];
    public $data = [];

    public function mount($dashboardCode)
    {
        $this->dashboardCode = $dashboardCode;
    }

    protected function loadData()
    {
        foreach (tab_langs() as $lang) {
            $suffix = $lang->status == 'default' ? '' : '_' . $lang->lang;
            foreach ($this->translatableFields as $field) {
                $dbField = $field . $suffix;
                $this->data[$dbField] = null;
            }
        }
    }

    public function save()
    {

        try {
            $this->validate();
            DB::beginTransaction();
            $maxSort = CompanyFaq::where('dashboard_code', $this->dashboardCode)->max('sort');
            $nextSort = ($maxSort !== null) ? $maxSort + 1 : 1;
            $this->status();

            $item = CompanyFaq::create([
                'dashboard_code' => $this->dashboardCode,
                'user_id' => auth()->id(),
                'question' => $this->data['question'],
                'answer' => $this->data['answer'],
                'status' => $this->data['status'],
                'sort' => $nextSort,
            ]);
            store_lang_for_array_data($item, $this->data, ['question', 'answer','status']);
            DB::commit();
            $this->dispatch('itemRender');
            $this->dispatch('insert', icon: 'success', title: 'Success', text: 'Certificate added successfully.');
            $this->reset('data');
        } catch (\Illuminate\Validation\ValidationException $e) {
            DB::rollBack();
            $messages = $e->validator->errors()->all();
            $errorMessage = implode('<br>', array_map(function ($error) {
                $error = str_replace('data.', '', $error);
                return "- $error";
            }, $messages));
            $this->dispatch('errorShow', icon: 'warning', title: 'Validation Error', text: $errorMessage);
        } catch (\Exception $e) {
            DB::rollBack();
            $this->dispatch('errorShow', icon: 'error', title: 'Error', text: $e->getMessage());
        }
    }

    public function render()
    {
        return view('livewire.dashboard.company.company-faq.create');
    }

    protected function rules()
    {
        $rules = [
        ];
        foreach (tab_langs() as $lang) {
            $suffix = $lang->status == 'default' ? '' : '_' . $lang->lang;
            $rules["data.question{$suffix}"] = $lang->status == 'default' ? 'required' : 'nullable';
            $rules["data.answer{$suffix}"] = $lang->status == 'default' ? 'required' : 'nullable';
            $rules["data.status{$suffix}"] = 'nullable|in:1,active,pending';
        }

        return $rules;
    }
}
