<?php

namespace App\Livewire\Dashboard\Company\CompanyFaq;

use Livewire\Attributes\Layout;
use Livewire\Attributes\On;
use Livewire\Component;
use App\Models\CompanyFaq;

class Manage extends Component
{
    public $items;
    public $dashboardCode;
    public $sort = [];

    public function mount($dashboard_code)
    {
        $this->items = CompanyFaq::where('dashboard_code', $dashboard_code)->get();
        $this->dashboardCode = $dashboard_code;
        foreach ($this->items as $item) {
            $this->sort[$item->id] = $item->sort;
        }
    }

    #[On('sortUpdate')]
    public function sortUpdate($id,$sort)
    {
        $faq = CompanyFaq::find($id);
        $this->authorize('update', $faq);
        if ($faq) {
            $faq->sort = $sort;
            $faq->save();
            $this->dispatch('tableRender');
            $this->dispatch('alert', icon: 'success', title: 'Updated');
        }
    }

    #[On('remove')]
    public function remove($id)
    {
        $item = CompanyFaq::findOrFail($id);
        try {
            $this->authorize('delete', $item);
            $item->delete();
            $this->items = CompanyFaq::where('dashboard_code', $this-$this->dashboardCode)->get();
            $this->dispatch('tableRender');
            $this->dispatch('insert', icon: 'info', title: 'Deleted', text: 'deleted successfully.');
        } catch (\Exception $e) {
            $this->dispatch('insert', icon: 'error', title: 'Error', text: 'Failed to delete. '.$e->getMessage());
        }
    }

    #[On('itemRender')]
    public function tableRender()
    {
        $this->items = CompanyFaq::where('dashboard_code', $this->dashboardCode)->get();
        $this->dispatch('tableRender');
    }

    #[Layout('components.layouts.app', [
        'assets' => ['table'],
        'theme' => '7'
    ])]
    public function render()
    {
        return view('livewire.dashboard.company.company-faq.manage', [
            'title' => 'Manage Company Faq',
            'page_title' => ['Company', 'Company Faq'],
        ]);
    }
}