<?php

namespace App\Livewire\Dashboard\Company\CompanyOffice;

use Livewire\Attributes\Layout;
use Livewire\Attributes\On;
use Livewire\Component;
use App\Models\OfficeInformation;

class Manage extends Component
{
    public $items;
    public $dashboardCode;
    public function mount($dashboard_code)
    {
        $this->items = OfficeInformation::with(['country','state','city'])
            ->where('dashboard_code', $dashboard_code)
            ->get();
        $this->dashboardCode = $dashboard_code;
    }

    #[On('remove')]
    public function remove($id)
    {
        $item = OfficeInformation::findOrFail($id);
        try {
            $this->authorize('delete', $item);
            $item->delete();
            $this->items = OfficeInformation::with(['country','state','city'])
                ->where('dashboard_code',$this->dashboardCode)
                ->get();
            $this->dispatch('insert', icon: 'info', title: 'Deleted', text: translateText('Information successfully deleted.', lang_admin()));
        } catch (\Exception $e) {
            $this->dispatch('insert', icon: 'error', title: 'Deleted', text: translateText('We encountered a problem deleting, please try again.', lang_admin()));
        }
    }

    #[On('itemRender')]
    public function tableRender()
    {
        $this->items = OfficeInformation::with(['country','state','city'])
            ->where('dashboard_code',$this->dashboardCode)
            ->get();
    }
    #[Layout('components.layouts.app', [
        'assets' => ['tom-select','country-manage'],
        'theme' => '7'
    ])]
    public function render()
    {
        return view('livewire.dashboard.company.company-office.manage',[
        'title' => 'Manage Company Office',
            'page_title' => ['Company', 'Company Office'],
        ]);
    }
}