<?php

namespace App\Livewire\Dashboard\ItemsAndServices\Product;

use App\Models\ProductCategory;
use Livewire\Attributes\Computed;
use Livewire\Component;
use Livewire\Attributes\On;

class CategorySelector extends Component
{
    public $category_id;

    #[Computed]
    public function categories()
    {
        return ProductCategory::with(['children.children' => function ($query) {
            $query->checkStatus()->orderBy('sort');
        }])
            ->where('parent_id', null)
            ->checkStatus()
            ->orderBy('sort')
            ->get();
    }

    public function render()
    {
        return view('livewire.dashboard.items-and-services.product.category-selector');
    }
}