<?php

namespace App\Livewire\Dashboard\ItemsAndServices\Product;

use App\Models\Product;
use Livewire\Attributes\Layout;
use Livewire\Attributes\On;
use Livewire\Component;

class Manage extends Component
{
    public $items;
    public $dashboardCode;
    public function mount($dashboard_code)
    {
        $this->items = Product::with('gallery','category','user')->where('dashboard_code', $dashboard_code)->get();
        $this->dashboardCode = $dashboard_code;
    }

    #[On('remove')]
    public function remove($id)
    {
        $item = Product::findOrFail($id);
        try {
            $this->authorize('delete', $item);
            $item->delete();
            $this->items = Product::where('dashboard_code', $this->dashboardCode)->get();
            $this->dispatch('tableRender');
            $this->dispatch('insert', icon: 'info', title: 'Deleted', text: 'Certificate deleted successfully.');
        } catch (\Exception $e) {
            $this->dispatch('insert', icon: 'error', title: 'Error', text: 'Failed to delete certificate.'.$e->getMessage());
        }
    }

    #[Layout('components.layouts.app', [
        'assets' => ['table'],
        'theme' => '7'
    ])]
    public function render()
    {
        return view('livewire.dashboard.items-and-services.product.manage', [
            'title' => 'Manage Product',
            'page_title' => ['Items And Services', 'Product'],
        ]);
    }
}