<?php

namespace App\Livewire\Dashboard\Layout;

use Livewire\Component;

class Sidebar extends Component
{
    public $fav_icon = '';
    public $logo = '';
    public $sidebarItem = [];

    public function mount()
    {
        $this->sidebarItem = $this->sidebar();
    }

    public function sidebar()
    {
        return [
            [
                'title' => '',
                'master' => [
                    [
                        'can' => '',
                        'title' => 'dashboard',
                        'icon' => 'fas fa-tachometer-alt',
                        'route' => 'dashboard',
                    ]
                ],
            ],
            /*basic*/  [
                'title' => 'basic',
                'master' => [
                    [
                        'can' => 'company_',
                        'title' => 'company',
                        'icon' => 'fas fa-users',
                        'route' => false,
                        'item' => [
                            [
                                'can' => 'list',
                                'title' => 'General Information',
                                'route' => 'general-information',
                                'pr' => auth()->user()->dashboard_code,
                            ],[
                                'title' => 'Contact Information',
                                'route' => 'contact-information',
                                'pr' => auth()->user()->dashboard_code,
                            ],[
                                'title' => 'Business  Information',
                                'route' => 'business-information',
                                'pr' => auth()->user()->dashboard_code,
                            ],[
                                'title' => 'Trading  Information',
                                'route' => 'trading-information',
                                'pr' => auth()->user()->dashboard_code,
                            ],[
                                'title' => 'Factory  Information',
                                'route' => 'factory-information',
                                'pr' => auth()->user()->dashboard_code,
                            ],[
                                'title' => 'Company Offices',
                                'route' => 'company-office.manage',
                                'pr' => auth()->user()->dashboard_code,
                            ],[
                                'title' => 'Quality Control',
                                'route' => 'quality-control',
                                'pr' => auth()->user()->dashboard_code,
                            ],[
                                'title' => 'Company Certificate',
                                'route' => 'company-certificate.manage',
                                'pr' => auth()->user()->dashboard_code,
                            ],[
                                'title' => 'Company Faq',
                                'route' => 'company-faq.manage',
                                'pr' => auth()->user()->dashboard_code,
                            ],
                        ]
                    ]
                ],
            ],
            [
                'title' => 'Items and services',
                'master' => [
                    [
                        'can' => 'company_',
                        'title' => 'product',
                        'icon' => 'fas fa-box',
                        'route' => false,
                        'item' => [
                            [
                                'can' => 'list',
                                'title' => 'Manage products',
                                'route' => 'product.manage',
                                'pr' => auth()->user()->dashboard_code,
                            ],[
                                'can' => 'list',
                                'title' => 'Add products',
                                'route' => 'product.create',
                                'pr' => auth()->user()->dashboard_code,
                            ],
                        ]
                    ]
                ],
            ],

        ];
    }

    public function render()
    {
        return view('livewire.dashboard.layout.sidebar');
    }
}