<?php

namespace App\Livewire\Dashboard\UserDashboard;

use Livewire\Component;
use Illuminate\Support\Facades\Auth;
use App\Models\ContactInformation;
use App\Models\GeneralInformation;
use Carbon\Carbon;

class ProfileView extends Component
{
    public $user;
    public $profilePhoto;
    public $companyName;
    public $countryFlag;
    public $countryName;
    public $membershipType = 'Free';
    public $accountType = '';
    public $memberSince;
    public $email;
    public $phoneNumber;
    public $companyAddress;

    public function mount()
    {
        $user = $this->user = Auth::user();
        $this->accountType = $user->getRoleNames()->first() ?? '';
        $this->loadProfileData();
    }

    protected function loadProfileData()
    {
        $generalInfo = GeneralInformation::where('dashboard_code', $this->user->dashboard_code)->first();
        $this->companyName = $generalInfo->company_name ?? $this->user->name;

        $contactInfo = ContactInformation::with('countries', 'state', 'city')->where('dashboard_code', $this->user->dashboard_code)->first();
        $this->profilePhoto = isset($contactInfo->profile) ? url($contactInfo->profile->path) : url('assets/dashboard/images/dashboard-11/user/12.jpg');

        if ($contactInfo) {
            $this->email = $contactInfo->email_address ?? $this->user->email ?? $this->user->username ?? 'N/A';
            $this->phoneNumber = $contactInfo->phone_number
                ? (($contactInfo->country_code1 ?? '') . ' ' . $contactInfo->phone_number)
                : 'N/A';
            $this->companyAddress = $this->formatAddress($contactInfo);
            $this->countryFlag = $contactInfo->countries->emoji ?? null;
            $this->countryName = $contactInfo->countries->name ?? null;
        } else {
            $this->email = $this->user->email ?? $this->user->username ?? 'N/A';
            $this->phoneNumber = 'N/A';
            $this->companyAddress = 'N/A';
            $this->countryFlag = null;
            $this->countryName = null;
        }

        $this->memberSince = Carbon::parse($this->user->created_at)->format('jS F, Y');
    }

    protected function formatAddress($contactInfo)
    {
        $parts = array_filter([
            $contactInfo->street ?? null,
            isset($contactInfo->city) ? $contactInfo->city->name : null,
            isset($contactInfo->state) ? $contactInfo->state->name : null,
            $contactInfo->post_code ?? null
        ]);

        return !empty($parts) ? implode(', ', $parts) : 'N/A';
    }

    public function render()
    {
        return view('livewire.dashboard.user-dashboard.profile-view');
    }
}