<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\File;

class About extends Model
{
    protected $guarded = ['id', 'created_at', 'updated_at'];

    public function photo()
    {
        return $this->morphOne('App\Models\Photo', 'pictures')->where('status', 'active')->where('type', 'photo');
    }

    public function langs()
    {
        return $this->morphMany('App\Models\Lang', 'langs');
    }

    public static function type_about($item)
    {
        switch ($item) {
            case 'about':
                $res = 'صفحه درباره ما';
                break;
            case 'home':
                $res = 'صفحه اصلی';
                break;
            case 'footer':
                $res = 'فوتر';
                break;
            case 'terms':
                $res = 'شرایط استفاده';
                break;
            case 'hyperlink':
                $res = 'خط مشی';
                break;
            case 'register':
                $res = 'صفحه ثبت نام';
                break;
            default:
                $res = 'ثبت نشده';
                break;

        }
        return $res;
    }

    protected static function boot()
    {
        parent::boot();

        static::deleting(function ($item) {
            if (count($item->langs)) {
                foreach ($item->langs as $lang) {
                    $lang->delete();
                }
            }

            if ($item->photo) {
                if (is_file($item->photo->path)) {
                    File::delete($item->photo->path);
                    delete_directory($item->photo->path);
                }
                $item->photo->delete();
            }
        });
    }
}