<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\File;

class Banner extends Model
{
    protected $guarded = ['id', 'created_at', 'updated_at'];

    public function photo()
    {
        return $this->morphOne('App\Models\Photo', 'pictures')->where('status','active')->where('type','photo');
    }
    public function photo_default()
    {
        return $this->morphOne('App\Models\Photo', 'pictures')->where('status','active')->where('type','photo_default');
    }

    public function type_place()
    {
        switch ($this->place)
        {
            case 'index_1':
                $res='صفحه اصلی(زیر اسلایدر)';
                break;
            case 'index_2':
                $res='صفحه اصلی(زیر محصولات)';
                break;
            case 'index_3':
                $res='صفحه اصلی(زیر فرم نیازسنجی)';
                break;
            case 'index_4':
                $res='صفحه اصلی(زیر suppliers)';
                break;
            case 'rfq':
                $res='صفحه rfq(بالای صفحه)';
                break;
            default:
                $res='ثبت نشده';
                break;

        }
        return $res;
    }public function type_status()
    {
        switch ($this->status)
        {
            case 'active':
                $res='<span class="badge badge-success">انتشار</span>';
                break;
            case 'pending':
                $res='<span class="badge badge-danger">عدم انتشار</span>';
                break;
            default:
                $res='<span class="badge badge-warning">نامشخص</span>';
                break;

        }
        return $res;
    }

    protected static function boot()
    {
        parent::boot();

        static::deleting(function ($item) {
            if($item->photo)
            {
                if(is_file($item->photo->path))
                {
                    File::delete($item->photo->path);
                    delete_directory($item->photo->path);
                }
                $item->photo->delete();
            }
            if($item->photo_default)
            {
                if(is_file($item->photo_default->path))
                {
                    File::delete($item->photo_default->path);
                    delete_directory($item->photo_default->path);
                }
                $item->photo_default->delete();
            }
        });
    }
}