<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\File;

class Country extends Model
{
    protected $guarded = ['id', 'created_at', 'updated_at'];
    public function mainMarkets()
    {
        return $this->hasMany(MainMarket::class);
    }

    public function generalInformations()
    {
        return $this->belongsToMany(GeneralInformation::class, 'main_markets', 'country_id', 'general_information_id');
    }

}