<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\File;

class GeneralInformation extends Model
{
    protected $guarded = ['id', 'created_at', 'updated_at'];

    protected $table = 'general_information';

    public function mainMarkets()
    {
        return $this->hasMany(MainMarket::class);
    }

    public function countries()
    {
        return $this->belongsToMany(Country::class, 'main_markets', 'general_information_id', 'country_id');
    }

    public function logo()
    {
        return $this->morphOne('App\Models\Photo', 'pictures')->where('status','active')->where('type','logo');
    }
    public function banner1()
    {
        return $this->morphOne('App\Models\Photo', 'pictures')->where('status','active')->where('type','banner1');
    }
    public function banner2()
    {
        return $this->morphOne('App\Models\Photo', 'pictures')->where('status','active')->where('type','banner2');
    }
    public function gallery()
    {
        return $this->morphMany('App\Models\Photo', 'pictures')->where('status','active')->where('type','gallery');
    }
    public function video()
    {
        return $this->morphOne('App\Models\Photo', 'pictures')->where('status','active')->where('type','video');
    }
    public function brochure()
    {
        return $this->morphOne('App\Models\Photo', 'pictures')->where('status','active')->where('type','brochure');
    }
    public function dashboard()
    {
        return $this->belongsTo('App\Models\User', 'dashboard_cod', 'dashboard_cod');
    }
    public function user_active()
    {
        return $this->belongsTo('App\Models\User', 'dashboard_code','dashboard_code')->where('status','active');
    }

    public function langs()
    {
        return $this->morphMany('App\Models\Lang', 'langs');
    }
    public function lang_active()
    {
        return $this->morphOne('App\Models\Lang', 'langs')->where('lang',app()->getLocale())->where('col_name','status')->where('text','active');
    }
    public function scopeCheckStatus($query)
    {
        // بررسی زبان پیش‌فرض و فیلتر بر اساس آن
        if (default_lang() == lang()) {
            return $query->where('status', 'active'); // برای زبان پیش‌فرض
        } else {
            return $query->whereHas('lang_active');  // برای زبان دوم
        }
    }

    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($item) {
            if($item->logo)
            {
                if(is_file($item->logo->path))
                {
                    File::delete($item->logo->path);
                    delete_directory($item->logo->path);
                }
                $item->logo->delete();
            }
            if($item->banner1)
            {
                if(is_file($item->banner1->path))
                {
                    File::delete($item->banner1->path);
                    delete_directory($item->banner1->path);
                }
                $item->banner1->delete();
            }
            if($item->banner2)
            {
                if(is_file($item->banner2->path))
                {
                    File::delete($item->banner2->path);
                    delete_directory($item->banner2->path);
                }
                $item->banner2->delete();
            }
            if($item->video)
            {
                if(is_file($item->video->path))
                {
                    File::delete($item->video->path);
                    delete_directory($item->video->path);
                }
                $item->video->delete();
            }
            if ($item->brochure) {
                if (is_file($item->brochure->path)) {
                    File::delete($item->brochure->path);
                    delete_directory($item->brochure->path);
                }
                $item->brochure->delete();
            }
            if(count($item->gallery))
            {
                foreach ($item->gallery as $photo)
                {
                    if(is_file($photo->path))
                    {
                        File::delete($photo->path);
                        delete_directory($photo->path);
                    }
                    $photo->delete();
                }
            }

            if(count($item->langs))
            {
                foreach ($item->langs as $lang)
                {
                    $lang->delete();
                }
            }
        });
    }
}
