<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\File;

class Landing extends Model
{
    protected $guarded = ['id', 'created_at', 'updated_at'];

    public function details()
    {
        return $this->hasMany('App\Models\LandingDetail', 'l_id');
    }
    public function comments()
    {
        return $this->hasMany('App\Models\Comment', 'item_id')->where('type','land');
    }
    public function comments_active()
    {
        return $this->hasMany('App\Models\Comment', 'item_id')->where('type','land')->where('status','active');
    }
    public function langs()
    {
        return $this->morphMany('App\Models\Lang', 'langs');
    }

    public function lang_active()
    {
        return $this->morphOne('App\Models\Lang', 'langs')->where('lang',app()->getLocale())->where('col_name','status')->where('text','active');
    }
    public function scopeCheckStatus($query)
    {
        // بررسی زبان پیش‌فرض و فیلتر بر اساس آن
        if (default_lang() == lang()) {
            return $query->where('status', 'active'); // برای زبان پیش‌فرض
        } else {
            return $query->whereHas('lang_active');  // برای زبان دوم
        }
    }

    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($item) {
            if(count($item->langs))
            {
                foreach ($item->langs as $lang)
                {
                    $lang->delete();
                }
            }
        });
    }
}