<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class OfficeInformation extends Model
{
    protected $guarded = ['id', 'created_at', 'updated_at'];

    protected $table = 'office_information';

    public function country()
    {
        return $this->belongsTo(Country::class, 'country_id');
    }

    public function state()
    {
        return $this->belongsTo(State::class, 'state_id');
    }

    public function city()
    {
        return $this->belongsTo(City::class, 'city_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($item) {
        });
    }
}