<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\File;

class Product extends Model
{
    protected $guarded = ['id', 'created_at', 'updated_at'];


    public function video()
    {
        return $this->morphOne('App\Models\Photo', 'pictures')->where('status','active')->where('type','video');
    }
    public function brochure()
    {
        return $this->morphOne('App\Models\Photo', 'pictures')->where('status','active')->where('type','brochure');
    }
    public function certificates()
    {
        return $this->morphMany('App\Models\Photo', 'pictures')->where('status','active')->where('type','certificates');
    }
    public function gallery()
    {
        return $this->morphMany('App\Models\Photo', 'pictures')->where('status','active')->where('type','gallery');
    }
    public function category()
    {
        return $this->belongsTo('App\Models\ProductCategory','category_id');
    }
    public function group()
    {
        return $this->belongsTo(Group::class,'group_id');
    }
    public function place_of_origin()
    {
        return $this->belongsTo(Country::class,'place_of_origin');
    }
    public function nearest_port()
    {
        return $this->belongsTo(Country::class,'nearest_port');
    }

    public function prices()
    {
        return $this->hasMany(Price::class);
    }
    public function priceSummary()
    {
        return $this->hasOne(ProductPriceSummary::class);
    }

    public function main_markets()
    {
        return $this->belongsToMany(Country::class, 'product_main_markets', 'product_id', 'country_id');
    }
    public function c1()
    {
        return $this->belongsTo('App\Models\ProductCategory','c_1');
    }
    public function c1_service_yes()
    {
        return $this->belongsTo('App\Models\ProductCategory','c_1')->where('service','yes');
    }
    public function c1_service_no()
    {
        return $this->belongsTo('App\Models\ProductCategory','c_1')->where('service','no');
    }
    public function c2()
    {
        return $this->belongsTo('App\Models\ProductCategory','c_2');
    }
    public function c3()
    {
        return $this->belongsTo('App\Models\ProductCategory','c_3');
    }
    public function c4()
    {
        return $this->belongsTo('App\Models\ProductCategory','c_4');
    }

    public function photo()
    {
        return $this->morphOne('App\Models\Photo', 'pictures')->where('status','active')->where('type','photo');
    }
    public function icon()
    {
        return $this->morphOne('App\Models\Photo', 'pictures')->where('status', 'active')->where('type', 'icon');
    }
    public function user()
    {
        return $this->belongsTo('App\Models\User', 'user_id');
    }
    public function user_active()
    {
        return $this->belongsTo('App\Models\User', 'user_id')->where('status','active');
    }
    /*public function prices()
    {
        return $this->hasMany('App\Models\ProductPrice', 'product_id')->orderBy('price');
    }
    public function price_last()
    {
        return $this->hasOne('App\Models\ProductPrice', 'product_id')->orderByDesc('price');
    }*/
    public function features()
    {
        return $this->hasMany('App\Models\ProductFeature', 'product_id');
    }
    public function langs()
    {
        return $this->morphMany('App\Models\Lang', 'langs');
    }
    public function lang_active()
    {
        return $this->morphOne('App\Models\Lang', 'langs')->where('lang',app()->getLocale())->where('col_name','status')->where('text','active');
    }
    public function scopeCheckStatus($query)
    {
        // بررسی زبان پیش‌فرض و فیلتر بر اساس آن
        if (default_lang() == lang()) {
            return $query->where('status', 'active'); // برای زبان پیش‌فرض
        } else {
            return $query->whereHas('lang_active');  // برای زبان دوم
        }
    }
    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($item) {
            if($item->photo)
            {
                if(is_file($item->photo->path))
                {
                    File::delete($item->photo->path);
                    delete_directory($item->photo->path);
                }
                $item->photo->delete();
            }
            if($item->video)
            {
                if(is_file($item->video->path))
                {
                    File::delete($item->video->path);
                    delete_directory($item->video->path);
                }
                $item->video->delete();
            }
            if ($item->icon) {
                if (is_file($item->icon->path)) {
                    File::delete($item->icon->path);
                    delete_directory($item->icon->path);
                }
                $item->icon->delete();
            }
            if(count($item->gallery))
            {
                foreach ($item->gallery as $photo)
                {
                    if(is_file($photo->path))
                    {
                        File::delete($photo->path);
                        delete_directory($photo->path);
                    }
                    $photo->delete();
                }
            }

            if(count($item->langs))
            {
                foreach ($item->langs as $lang)
                {
                    $lang->delete();
                }
            }
            if(count($item->prices))
            {
                foreach ($item->prices as $price)
                {
                    $price->delete();
                }
            }
            if(count($item->features))
            {
                foreach ($item->features as $feature)
                {
                    $feature->delete();
                }
            }

        });
    }
}
