<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\File;

class ProductCategory extends Model
{
    protected $guarded = ['id', 'created_at', 'updated_at'];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
    public function businesses()
    {
        return $this->belongsToMany(BusinessInformation::class, 'business_information_categories', 'category_id', 'business_information_id');
    }
    public function photo()
    {
        return $this->morphOne('App\Models\Photo', 'pictures')->where('status', 'active')->where('type', 'photo');
    }

    public function icon()
    {
        return $this->morphOne('App\Models\Photo', 'pictures')->where('status', 'active')->where('type', 'icon');
    }

    public function parent()
    {
        return $this->belongsTo(ProductCategory::class, 'parent_id');
    }

    public function children()
    {
        return $this->hasMany(ProductCategory::class, 'parent_id')->orderBy('sort');
    }

    public function grandchildren()
    {
        return $this->hasManyThrough(
            ProductCategory::class,
            ProductCategory::class,
            'parent_id',
            'parent_id',
            'id',
            'id'
        )->orderBy('sort');
    }

    public function descendants()
    {
        return $this->children()->with('descendants');
    }

    public function ancestors()
    {
        return $this->parent()->with('ancestors');
    }
    public function parent_null()
    {
        return $this->belongsTo(ProductCategory::class, 'parent_id')->where('user_id',1);
    }
    public function parent_service_yes()
    {
        return $this->belongsTo(ProductCategory::class, 'parent_id')->where('service','yes');
    }
    public function parent_service_no()
    {
        return $this->belongsTo(ProductCategory::class, 'parent_id')->where('service','no');
    }
    public function childs()
    {
        return $this->hasMany(ProductCategory::class, 'parent_id')->orderBy('sort');
    }
    public function childs_active()
    {
        return $this->hasMany(ProductCategory::class, 'parent_id')->checkStatus()->orderBy('sort');
    }

    public function products()
    {
        return $this->hasMany(Product::class, 'category_id');
    }
    public function products_active()
    {
        return $this->hasMany(Product::class, 'category_id')->checkStatus();
    }
    public function products_c1()
    {
        return $this->hasMany(Product::class, 'c_1')->checkStatus();
    }
    public static function childs_active_c1($cat,$user_id)
    {
        if($cat->childs_active)
        {
            return ProductCategory::where('parent_id',$cat->id)->whereHas('products_c2',function ($p) use($user_id){
                $p->where('user_id',$user_id);
            })->get();
//            return $cat->childs_active->whereHas('products_c1',function ($p) use($user_id){
//                $p->where('user_id',$user_id);
//            })->orderBy('sort');
        }

        return null;
    }
    public function products_c2()
    {
        return $this->hasMany(Product::class, 'c_2')->checkStatus();
    }
    public static function childs_active_c2($user_id)
    {
        return $this->hasMany(ProductCategory::class, 'parent_id')->checkStatus()->whereHas('products_c2',function ($p) use($user_id){
            $p->where('user_id',$user_id);
        })->orderBy('sort');
    }
    public function products_c3()
    {
        return $this->hasMany(Product::class, 'c_3')->checkStatus();
    }
    public static function childs_active_c3($user_id)
    {
        return $this->hasMany(ProductCategory::class, 'parent_id')->checkStatus()->whereHas('products_c3',function ($p) use($user_id){
            $p->where('user_id',$user_id);
        })->orderBy('sort');
    }
    public function products_c4()
    {
        return $this->hasMany(Product::class, 'c_4')->checkStatus();
    }
    public static function childs_active_c4($user_id)
    {
        return $this->hasMany(ProductCategory::class, 'parent_id')->checkStatus()->whereHas('products_c4',function ($p) use($user_id){
            $p->where('user_id',$user_id);
        })->orderBy('sort');
    }
    public function sourcing_magazine()
    {
        return $this->hasMany(SourcingMagazine::class, 'cat_id')->checkStatus();
    }
    public function langs()
    {
        return $this->morphMany('App\Models\Lang', 'langs');
    }

    public function lang_active()
    {
        return $this->morphOne('App\Models\Lang', 'langs')->where('lang', app()->getLocale())->where('col_name', 'status')->where('text', 'active');
    }

    public function scopeCheckStatus($query)
    {
            if (default_lang() == lang()) {
                return $query->where('status', 'active'); // برای زبان پیش‌فرض
            } else {
                return $query->whereHas('lang_active');  // برای زبان دوم
            }
    }

    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($item) {
            if ($item->photo) {
                if (is_file($item->photo->path)) {
                    File::delete($item->photo->path);
                    delete_directory($item->photo->path);
                }
                $item->photo->delete();
            }
            if ($item->icon) {
                if (is_file($item->icon->path)) {
                    File::delete($item->icon->path);
                    delete_directory($item->icon->path);
                }
                $item->icon->delete();
            }

            if (count($item->langs)) {
                foreach ($item->langs as $lang) {
                    $lang->delete();
                }
            }

        });
    }
}
