<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\File;

class Rfq extends Model
{
    protected $guarded = ['id', 'created_at', 'updated_at'];

    protected $table = 'rfqs';
    public function file()
    {
        return $this->morphMany('App\Models\Photo', 'pictures')->where('status','active')->where('type','file');
    }
    public function category()
    {
        return $this->belongsTo('App\Models\ProductCategory','product_category_id');
    }

    public function user()
    {
        return $this->belongsTo('App\Models\User', 'user_id');
    }
    public function user_active()
    {
        return $this->belongsTo('App\Models\User', 'user_id')->where('status','active');
    }

    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($item) {
            if(count($item->file))
            {
                foreach ($item->file as $photo)
                {
                    if(is_file($photo->path))
                    {
                        File::delete($photo->path);
                        delete_directory($photo->path);
                    }
                    $photo->delete();
                }
            }
        });
    }
}
