<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RfqForm extends Model
{
    protected $guarded = ['id', 'created_at', 'updated_at'];
    protected $table = 'rfq_form';
    public static function type_rfq_fields($item)
    {
        switch ($item) {
            case 'units':
                $res = 'واحد اندازه‌گیری';
                break;
            case 'trade_terms':
                $res = 'شرایط تجاری';
                break;
            case 'budget_limit':
                $res = 'حدود بودجه';
                break;
            case 'expected_unit_price':
                $res = 'قیمت مورد انتظار واحد';
                break;
            case 'bying_frequency':
                $res = 'تکرار خرید';
                break;
            case 'shipping_method':
                $res = 'روش حمل و نقل';
                break;
            case 'payment_terms':
                $res = 'شرایط پرداخت';
                break;
            case 'rfq_expiry':
                $res = 'انقضای درخواست پیش‌فاکتور';
                break;
            default:
                $res = 'ثبت نشده';
                break;
        }
        return $res;
    }
    public static function color_rfq_fields($item)
    {
        switch ($item) {
            case 'units':
                $res = '#FFFFE0';
                break;
            case 'trade_terms':
                $res = '#eaeaff';
                break;
            case 'budget_limit':
                $res = '#d8f8d8';
                break;
            case 'expected_unit_price':
                $res = '#fdf3fd';
                break;
            case 'bying_frequency':
                $res = '#e4faf7';
                break;
            case 'shipping_method':
                $res = '#fceded';
                break;
            case 'payment_terms':
                $res = '#fff6f0';
                break;
            case 'rfq_expiry':
                $res = '#dbe6ff';
                break;
            default:
                $res = 'ثبت نشده';
                break;
        }
        return $res;
    }
    public function langs()
    {
        return $this->morphMany('App\Models\Lang', 'langs');
    }

    public function lang_active()
    {
        return $this->morphOne('App\Models\Lang', 'langs')->where('lang', app()->getLocale())->where('col_name', 'status')->where('text', 'active');
    }

    public function scopeCheckStatus($query)
    {
        if (default_lang() == lang()) {
            return $query->where('status', 'active');
        } else {
            return $query->whereHas('lang_active');
        }
    }

    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($item) {
            if (count($item->langs)) {
                foreach ($item->langs as $lang) {
                    $lang->delete();
                }
            }

        });
    }
}
