<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\File;

class Select extends Model
{
    protected $guarded = ['id', 'created_at', 'updated_at'];
    public function user_business()
    {
        return $this->belongsToMany('App\Models\User','user_business_type','business_type_id','user_id');
    }
    public function user_purchasing()
    {
        return $this->hasMany('App\Models\User', 'purchasing_frequency_id');
    }
    public function user_volume()
    {
        return $this->hasMany('App\Models\User', 'annual_purchase_volume_id');
    }
    public function user_certificate()
    {
        return $this->hasMany('App\Models\UserCertificate', 'type_id');
    }
    public function langs()
    {
        return $this->morphMany('App\Models\Lang', 'langs');
    }
    public function lang_active()
    {
        return $this->morphOne('App\Models\Lang', 'langs')->where('lang',app()->getLocale())->where('col_name','status')->where('text','active');
    }
//    public function get_type()
//    {
//      switch ($this->type)
//      {
//          case 'business_type':
//              return 'Business Type';
//              break;
//          case 'purchasing_frequency':
//              return 'Purchasing Frequency';
//              break;
//          case 'annual_purchase_volume':
//              return 'Annual Purchase Volume';
//              break;
//          default:
//              return '__';
//              break;
//      }
//    }
    public static function get_type($type)
    {
      switch ($type)
      {
          case 'business_type':
              return 'Business Type/نوع کسب وکار';
              break;
          case 'purchasing_frequency':
              return 'Purchasing Frequency/فرکانس خرید';
              break;
          case 'annual_purchase_volume':
              return 'Annual Purchase Volume/حجم خرید سالانه';
              break;
          case 'certificate':
              return 'Document Type Certificate/نوع گواهینامه';
              break;
          default:
              return '__';
              break;
      }
    }
    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($item) {
            if(count($item->langs))
            {
                foreach ($item->langs as $lang)
                {
                    $lang->delete();
                }
            }
        });
    }
}