<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TradingInformation extends Model
{
    protected $table = 'trading_information';

    protected $guarded = ['id', 'created_at', 'updated_at'];

    protected $casts = [
        'terms_of_trades' => 'array',
    ];

    public function dashboard()
    {
        return $this->belongsTo('App\Models\User', 'dashboard_code','dashboard_code');
    }
    public function user_active()
    {
        return $this->belongsTo('App\Models\User', 'dashboard_code','dashboard_code')->where('status','active');
    }
}