<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\File;

class Transport extends Model
{
    protected $guarded = ['id', 'created_at', 'updated_at'];


    public function photos()
    {
        return $this->morphMany('App\Models\Photo', 'pictures')->where('status', 'active')->where('type', 'photos');
    }

    public function video()
    {
        return $this->morphOne('App\Models\Photo', 'pictures')->where('status', 'active')->where('type', 'video');
    }

    public function langs()
    {
        return $this->morphMany('App\Models\Lang', 'langs');
    }

    public function lang_active()
    {
        return $this->morphOne('App\Models\Lang', 'langs')->where('lang', app()->getLocale())->where('col_name', 'status')->where('text', 'active');
    }

    public function scopeCheckStatus($query)
    {
        // بررسی زبان پیش‌فرض و فیلتر بر اساس آن
        if (default_lang() == lang()) {
            return $query->where('status', 'active'); // برای زبان پیش‌فرض
        } else {
            return $query->whereHas('lang_active');  // برای زبان دوم
        }
    }

    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($item) {
            if (count($item->photos)) {
                foreach ($item->photos as $photo) {
                    if (is_file($photo->path)) {
                        File::delete($photo->path);
                        delete_directory($photo->path);
                    }
                    $photo->delete();
                }
            }
            if ($item->video) {
                if (is_file($item->video->path)) {
                    File::delete($item->video->path);
                    delete_directory($item->video->path);
                }
                $item->video->delete();
            }
            if (count($item->langs)) {
                foreach ($item->langs as $lang) {
                    $lang->delete();
                }
            }

        });
    }
}