<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\File;

class UserWork extends Model
{
    protected $guarded = ['id', 'created_at', 'updated_at'];

    public function user()
    {
        return $this->belongsTo('App\Models\User', 'user_id');
    }
    public function file_zip()
    {
        return $this->morphOne('App\Models\Photo', 'pictures')->where('status','active')->where('type','file_zip');
    }


    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($item) {
            if($item->file_zip)
            {
                if(is_file($item->file_zip->path))
                {
                    File::delete($item->file_zip->path);
                }
                $item->file_zip->delete();
            }
        });
    }
}