<?php

namespace App\Policies;

use App\Models\CompanyCertificate;
use App\Models\User;

class CompanyCertificatePolicy
{
    private function isOwner(?User $user, CompanyCertificate $companyCertificate): bool
    {
        return $user?->dashboard_code === $companyCertificate->dashboard_code;
    }

    public function delete(?User $user, CompanyCertificate $companyCertificate): bool
    {
        return $this->isOwner($user, $companyCertificate);
    }

    public function update(?User $user, CompanyCertificate $companyCertificate): bool
    {
        return $this->isOwner($user, $companyCertificate);
    }
}
