<?php

namespace App\Policies;

use App\Models\CompanyFaq;
use App\Models\User;

class CompanyFaqPolicy
{
    private function isOwner(?User $user, CompanyFaq $companyFaq): bool
    {
        return $user?->dashboard_code === $companyFaq->dashboard_code;
    }
    public function delete(?User $user, CompanyFaq $companyFaq): bool
    {
        return $this->isOwner($user, $companyFaq);
    }
    public function update(?User $user, CompanyFaq $companyFaq): bool
    {
        return $this->isOwner($user, $companyFaq);
    }
}