<?php

namespace App\Policies;

use App\Models\OfficeInformation;
use App\Models\User;

class OfficeInformationPolicy
{
    private function isOwner(?User $user, OfficeInformation $officeInformation): bool
    {
        return $user?->dashboard_code === $officeInformation->dashboard_code;
    }
    public function delete(?User $user, OfficeInformation $officeInformation): bool
    {
        return $this->isOwner($user, $officeInformation);
    }
    public function update(?User $user, OfficeInformation $officeInformation): bool
    {
        return $this->isOwner($user, $officeInformation);
    }
}