<?php

namespace App\Policies;

use App\Models\Product;
use App\Models\User;

class ProductPolicy
{
    private function isOwner(?User $user, Product $product): bool
    {
        return $user?->dashboard_code === $product->dashboard_code;
    }
    public function delete(?User $user, Product $product): bool
    {
        return $this->isOwner($user, $product);
    }
    public function update(?User $user, Product $product): bool
    {
        return $this->isOwner($user, $product);
    }
}