<?php
namespace App\Services;

use Illuminate\Support\Facades\Cache;
use App\Models\Country;
use App\Models\State;
use App\Models\City;

class DataCacheService
{
    public static function getCountries()
    {
        return Cache::remember('countries', now()->addMonth(), function () {
            return Country::orderBy('name')->pluck('name', 'id')->all();
        });
    }

    public static function getStates()
    {
        return Cache::remember('states', now()->addMonth(), function () {
            return State::orderBy('name')->get(['id', 'name', 'country_id']);
        });
    }

    public static function getCities()
    {
        return Cache::remember('cities', now()->addMonth(), function () {
            return City::orderBy('name')->get(['id', 'name', 'state_id']);
        });
    }

    public static function getTimeZones()
    {
        return Cache::remember('time_zones', now()->addMonth(), function () {
            return Country::orderBy('name')
                ->get(['timezones', 'name'])
                ->mapWithKeys(function ($item) {
                    $timezones = json_decode($item->timezones, true);
                    $zoneName = isset($timezones[0]['zoneName']) ? $timezones[0]['zoneName'] : null;
                    return [$zoneName => "{$item->name} ({$zoneName})"];
                })
                ->all();
        });
    }
}