<?php

return [
    //The merchant config
    'merchant' => [
        //store
        'clientId' => '700692450331',
        'storeKey' => '@Dib_14040101',
        'storeType' => '3D_PAY_HOSTING',
        'okUrl' => url('nestpay/confirm/1'),
        'failUrl' => url('nestpay/confirm/1'),
        '3DGateUrl' => 'https://spos.isbank.com.tr/servlet/est3Dgate',

        //API
        'apiName' => 'eminadmin',
        'apiPassword' => 'FLDM',
        'apiEndpointUrl' => 'https://spos.isbank.com.tr/servlet/cc5ApiServer',
    ],

    //Throw exceptions or not 
    //If set to false the exception will still be available in \Cubes\Nestpay\Laravel\NestpayPaymentProcessedErrorEvent 
    'throwExceptions' => true,

    //The class of the eloquen model which must implement \Cubes\Netpay\Payment interface
    //If set ti null the PDO will be used on table nestpay_payments
    'paymentModel' => \App\Models\NestpayPayment::class,

    //nestpay::handle-unprocessed-payments command settings

    //the payment is not going to be considered as "unprocessed" if it is younger than -900 seconds
    //even if it has propertu "processed" equals 0.
    //this is because the customer need some time to enter creditcard number on hosted payment page
    //default is 900 seconds or 15 minutes
    'unprocessed_payments_not_before' => 900, //seconds

    //for how long the unprocess payment is going to be kept in that state
    // after this time to live, the unprocessed payment is going to be marked as processed (processed = 1)
    //default is 5 days
    'unprocessed_payments_time_to_live' => 432000, //seconds

    //timeout between two Nestpay API calls in seconds
    'unprocessed_payments_api_call_timeout' => 2, //seconds
];