<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('photos', function (Blueprint $table) {
            $table->id();
            $table->integer('pictures_id')->nullable();
            $table->string('pictures_type',250)->nullable();
            $table->string('type',100)->nullable();
            $table->text('path')->nullable();
            $table->string('alt',250)->nullable();
            $table->enum('opt', ['yes','no'])->default('no');
            $table->enum('status', ['active','pending'])->default('active');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('photos');
    }
};
