@extends('admin.layouts.app',['req'=>true])

@section('content')
  <div class="row mt-5">
    <div class="col-xl-12 col-md-12 col-lg-12">
      <div class="card">
        <div class="card-header  border-0">
          <h4 class="card-title">
            {{$title}}
          </h4>
        </div>
        <hr>

        <div class="card-body">
          {{ Form::open(array('route' => 'admin.permission-cat.store', 'method' => 'POST','id'=>'form_req')) }}
          <div class="row">
            <div class="col-md-5">
              <div class="form-group">
                {{Form::label('table_name', translateText('نام جدول',lang_admin()).' *')}}
                {{Form::text('table_name', null, array('class' => 'form-control','required'))}}
              </div>
            </div>
            <div class="col-md-2">
              <div class="form-group">
                {{Form::label('sort_by', translateText('مرتب سازی',lang_admin()))}}
                {{Form::number('sort_by', $sort_number, array('class' => 'form-control d-ltr text-left'))}}
              </div>
            </div>
            <div class="col-md-5">
              <div class="form-group">
                {{Form::label('access_code', translateText('ابتدای کد دسترسی',lang_admin()).' *')}}
                {{Form::text('access_code', null, array('class' => 'form-control d-ltr text-left'))}}
              </div>
            </div>
            <div class="col-md-12 text-left">
              <hr/>
              {{Form::submit(translateText('افزودن',lang_admin()),array('class'=>'btn btn-primary float-left','onclick'=>"return confirm('برای ارسال فرم مطمئن هستید؟')"))}}
            </div>
          </div>
          {{ Form::close() }}
        </div>
      </div>
    </div>
  </div>
@endsection
@push('in_tag_script')

@endpush
