@extends('admin.layouts.app',['req'=>true,'editor'=>true,'file_upload'=>true])

@section('content')
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header border-0">
                    <h4 class="card-title">{{ $title }}</h4>
                </div>

                <div class="card-body">
                    {{ Form::model($item, ['route' => ['admin.business-information.update', $item->id], 'method' => 'PATCH', 'id' => 'form_req']) }}
                    {{ Form::hidden('id', $item->id) }}

                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                {{ Form::label('bussiness_type',translateText( 'نوع کسب‌وکار ',lang_admin()).'*') }}
                                {{ Form::select('bussiness_type[]', $bussiness_types, json_decode($item->bussiness_type,true), ['class' => 'form-control select2-show-search custom-select', 'multiple']) }}
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group">
                                {{ Form::label('category_id', translateText('دسته‌بندی کسب‌وکار ', lang_admin()).'*') }}
                                {{ Form::select('category_id[]', $categories, $item->categories->pluck('id')->toArray(), ['class' => 'form-control select2-show-search custom-select', 'multiple']) }}
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                {{ Form::label('registration_number',translateText( 'شماره ثبت ',lang_admin())) }}
                                {{ Form::number('registration_number', $item->registration_number, ['class' => 'form-control']) }}
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                {{ Form::label('ownership_model',translateText( 'مدل مالکیت ',lang_admin())) }}
                                {{ Form::select('ownership_model', $ownership_models, $item->ownership_model, ['class' => 'form-control select2-show-search custom-select']) }}
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group">
                                {{ Form::label('main_product_keywords',translateText( 'کلمات کلیدی محصولات اصلی ',lang_admin()).'*') }}
                                <div id="product-keywords-container">
                                    @if($item->main_product_keywords)
                                        @foreach(json_decode($item->main_product_keywords,true) as $keyword)
                                            <div class="d-flex mb-2">
                                                {{ Form::text('main_product_keywords[]', $keyword, ['class' => 'form-control me-2', 'placeholder' => 'کلمه کلیدی محصول']) }}
                                                <button type="button" class="btn btn-danger remove-keyword">{{translateText( 'حذف',lang_admin())}}</button>
                                            </div>
                                        @endforeach
                                    @endif
                                </div>
                                <button type="button" id="add-keyword" class="btn btn-primary mt-2">{{translateText( 'اضافه کردن کلمه کلیدی',lang_admin())}}</button>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                {{ Form::label('tax_identification_number', 'شماره مالیاتی') }}
                                {{ Form::number('tax_identification_number', $item->tax_identification_number, ['class' => 'form-control']) }}
                                <small class="text-muted">{{translateText( 'شماره مالیاتی شما فقط برای تأیید هویت استفاده می‌شود و با تأمین‌کنندگان به اشتراک گذاشته نمی‌شود.',lang_admin())}}</small>
                            </div>
                        </div>

                        <div class="col-md-12 text-left">
                          <hr>
                            {{Form::submit(translateText('ویرایش',lang_admin()),array('class'=>'btn btn-primary','onclick'=>"return confirm('".translateText('برای ارسال فرم مطمئن هستید؟',lang_admin())."')"))}}
                        </div>
                    </div>
                    {{ Form::close() }}
                </div>
            </div>
        </div>
    </div>
@endsection

@section('in_tag_script')
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const container = document.getElementById('product-keywords-container');
            const addButton = document.getElementById('add-keyword');

            addButton.addEventListener('click', function () {
                const newRow = document.createElement('div');
                newRow.classList.add('d-flex', 'mb-2');
                newRow.innerHTML = `
            <input type="text" name="main_product_keywords[]" class="form-control me-2">
            <button type="button" class="btn btn-danger remove-keyword">حذف</button>
        `;
                container.appendChild(newRow);
            });

            container.addEventListener('click', function (e) {
                if (e.target.classList.contains('remove-keyword')) {
                    e.target.parentElement.remove();
                }
            });
        });
    </script>
@endsection