@extends('admin.layouts.app',['tbl'=>true])

@section('content')
    <style>
        .box-sh {
            box-shadow: 0 0 2px 0 #666;
            border-radius: 10px;
            padding: 15px 15px;
        }

    </style>

    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header border-0">
                    <h4 class="w-100">
                        {{$title}}
                        @can('company_form_create')
                            <a href="{{ route('admin.company-form.create') }}" class="btn btn-primary float-left">
                                {{ translateText('افزودن', lang_admin()) }}
                            </a>
                        @endcan
                    </h4>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-vcenter text-wrap table-bordered border-bottom" id="tbl_1">
                            <thead>
                            <tr>
                                <th class="border-bottom-0">#</th>
                                <th class="border-bottom-0">{{ translateText('عنوان', lang_admin()) }}</th>
                                <th class="border-bottom-0">{{ translateText('مکان', lang_admin()) }}</th>
                                @can('company_form_sort')
                                    <th class="border-bottom-0">{{ translateText('Sort', lang_admin()) }}</th>
                                @endcan
                                @canany(['company_form_edit','company_form_delete'])
                                    <th class="border-bottom-0">{{ translateText('عملیات', lang_admin()) }}</th>
                                @endcan
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($items as $key => $item)
                                <tr style="background-color: {{$item->color_fields($item->type)}}">
                                    <td dir="ltr">{{ $key + 1 < 10 ? "0" . ($key + 1) : $key + 1 }}</td>
                                    <td>{{ $item->title }}</td>
                                    <td>{{ translateText($item->type_fields($item->type), lang_admin()) }}</td>
                                    @can('company_form_sort')
                                        <td>
                                            {!! Form::open(['method' => 'POST', 'route' => ['admin.company-form.sort', $item->id]]) !!}
                                            <input type="number" name="sort" class="form-control w-60px"
                                                   value="{{ $item->sort }}" onchange="return this.form.submit()">
                                            {!! Form::close() !!}
                                        </td>
                                    @endcan
                                    @canany(['company_form_edit','company_form_delete'])
                                        <td>
                                            <div class="d-flex">
                                                @can('company_form_edit')
                                                    <a href="{{ route('admin.company-form.edit', $item->id) }}" class="action-btns1">
                                                        <i class="feather feather-edit-2 text-success"
                                                           data-toggle="tooltip" data-placement="top"
                                                           title="{{ translateText('ویرایش', lang_admin()) }}"></i>
                                                    </a>
                                                @endcan
                                                @can('company_form_delete')
                                                    {!! Form::open(['method' => 'DELETE', 'route' => ['admin.company-form.destroy', $item->id]]) !!}
                                                    <button class="action-btns1" data-toggle="tooltip" data-placement="top"
                                                            title="{{ translateText('حذف', lang_admin()) }}"
                                                            onclick="return confirm('{{ translateText('برای حذف مطمئن هستید؟', lang_admin()) }}')">
                                                        <i class="feather feather-trash-2 text-danger"></i>
                                                    </button>
                                                    {!! Form::close() !!}
                                                @endcan
                                            </div>
                                        </td>
                                    @endcan
                                </tr>
                            @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection