@extends('admin.layouts.app',['req'=>true,'editor'=>true])

@section('content')
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header border-0">
                    <h4 class="card-title">{{$title}}</h4>
                </div>

                <div class="card-body">
                    {{ Form::model($item, [
                        'route' => ['admin.office-information.update', $item->id],
                        'method' => 'PATCH',
                        'id' => 'head-office-form'
                    ]) }}

                    <h5>{{ translateText($item->type == 'head' ? 'دفتر مرکزی':'شعبه', lang_admin()) }}</h5>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                {{ Form::label('country_id', translateText('کشور', lang_admin()).'*') }}
                                {{ Form::select('country_id', $country, $item->country_id, ['class' => 'form-control select2-show-search custom-select', 'id' => 'country-select']) }}
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                {{ Form::label('state_id', translateText('استان', lang_admin()).'*') }}
                                {{ Form::select('state_id', [], $item->state_id, ['class' => 'form-control select2-show-search custom-select', 'id' => 'state-select', 'disabled' => true]) }}
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                {{ Form::label('city_id', translateText('شهر', lang_admin()).'*') }}
                                {{ Form::select('city_id', [], $item->city_id, ['class' => 'form-control select2-show-search custom-select', 'id' => 'city-select', 'disabled' => true]) }}
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                {{ Form::label('street', translateText('خیابان', lang_admin()).'*') }}
                                {{ Form::text('street', $item->street, [
                                    'class' => 'form-control'
                                ]) }}
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                {{ Form::label('zip_code', translateText('کد پستی', lang_admin()).'*') }}
                                {{ Form::text('zip_code', $item->zip_code, [
                                    'class' => 'form-control'
                                ]) }}
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group">
                                {{ Form::label('time_zone', translateText('منطقه زمانی', lang_admin()).'*') }}
                                {{ Form::select('time_zone', $time_zone, $item->time_zone, [
                                    'class' => 'form-control select2-show-search custom-select'
                                ]) }}
                            </div>
                        </div>

                        <div class="col-md-12 text-left">
                            {{Form::submit(translateText('ویرایش دفتر مرکزی', lang_admin()), [
                                'class' => 'btn btn-primary',
                                'onclick' => "return confirm('".translateText('برای ارسال فرم مطمئن هستید؟', lang_admin())."')"
                            ])}}
                        </div>
                    </div>
                    {{Form::close()}}
                </div>
            </div>
        </div>
    </div>
@endsection

@section('in_tag_script')
    <script>
        $(document).ready(function () {
            const countrySelect = $('#country-select');
            const stateSelect = $('#state-select');
            const citySelect = $('#city-select');


            const selectedCountryId = countrySelect.val();
            const selectedStateId = "{{ $item->state_id }}";
            const selectedCityId = "{{ $item->city_id }}";

            if (selectedCountryId) {
                const getStatesUrl = "{{ route('get.states', ':countryId') }}".replace(':countryId', selectedCountryId);
                $.ajax({
                    url: getStatesUrl,
                    type: 'GET',
                    success: function (states) {
                        stateSelect.empty().append('<option value="" disabled selected></option>').prop('disabled', false);
                        $.each(states, function (index, state) {
                            const isSelected = state.id == selectedStateId ? 'selected' : '';
                            stateSelect.append('<option value="' + state.id + '" ' + isSelected + '>' + state.name + '</option>');
                        });

                        // اگر استانی انتخاب‌شده وجود دارد، شهرها را واکشی کنید
                        if (selectedStateId) {
                            const getCityUrl = "{{ route('get.cities', ':stateId') }}".replace(':stateId', selectedStateId);
                            $.ajax({
                                url: getCityUrl,
                                type: 'GET',
                                success: function (cities) {
                                    citySelect.empty().append('<option value="" disabled selected></option>').prop('disabled', false);
                                    $.each(cities, function (index, city) {
                                        const isSelected = city.id == selectedCityId ? 'selected' : '';
                                        citySelect.append('<option value="' + city.id + '" ' + isSelected + '>' + city.name + '</option>');
                                    });
                                },
                                error: function () {
                                    alert('خطا در دریافت شهر‌ها');
                                }
                            });
                        }
                    },
                    error: function () {
                        alert('خطا در دریافت استان‌ها');
                    }
                });
            }

            // واکشی استان‌ها هنگام تغییر کشور
            countrySelect.on('change', function () {
                const countryId = $(this).val();

                stateSelect.empty().append('<option value="" disabled selected></option>').prop('disabled', true);
                citySelect.empty().append('<option value="" disabled selected></option>').prop('disabled', true);

                if (countryId) {
                    const getStatesUrl = "{{ route('get.states', ':countryId') }}".replace(':countryId', countryId);
                    $.ajax({
                        url: getStatesUrl,
                        type: 'GET',
                        success: function (states) {
                            stateSelect.prop('disabled', false);
                            $.each(states, function (index, state) {
                                stateSelect.append('<option value="' + state.id + '">' + state.name + '</option>');
                            });
                        },
                        error: function () {
                            alert('خطا در دریافت استان‌ها');
                        }
                    });
                }
            });

            // واکشی شهر‌ها هنگام تغییر استان
            stateSelect.on('change', function () {
                const stateId = $(this).val();

                citySelect.empty().append('<option value="" disabled selected></option>').prop('disabled', true);
                if (stateId) {
                    const getCityUrl = "{{ route('get.cities', ':stateId') }}".replace(':stateId', stateId);
                    $.ajax({
                        url: getCityUrl,
                        type: 'GET',
                        success: function (cities) {
                            citySelect.prop('disabled', false);
                            $.each(cities, function (index, city) {
                                citySelect.append('<option value="' + city.id + '">' + city.name + '</option>');
                            });
                        },
                        error: function () {
                            alert('خطا در دریافت شهر‌ها');
                        }
                    });
                }
            });
        });
    </script>
@endsection