@extends('admin.layouts.app',['req'=>true,'editor'=>true,'file_upload'=>true])

@section('content')
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header border-0">
                    <h4 class="card-title">{{ $title }}</h4>
                </div>

                <div class="card-body">
                    {{ Form::model($item, ['route' => ['admin.trading-information.update', $item->id], 'method' => 'PATCH', 'id' => 'form_req']) }}
                    {{ Form::hidden('id', $item->id) }}

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                {{ Form::label('import_export_license', translateText('مجوز واردات و صادرات', lang_admin()).'*') }}
                                {{ Form::select('import_export_license', ['Yes' => 'بله', 'No' => 'خیر'], $item->import_export_license, ['class' => 'form-control']) }}
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                {{ Form::label('annual_turnover', translateText('گردش مالی سالانه', lang_admin()).'*') }} <span dir="ltr">(Million US$)</span>
                                {{ Form::select('annual_turnover', $annual_turnovers, $item->annual_turnover, ['class' => 'form-control select2-show-search']) }}
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                {{ Form::label('export_revenue', translateText('درآمد صادراتی', lang_admin()).'*') }} <span dir="ltr">(Million US$)</span>
                                {{ Form::select('export_revenue', $export_revenues, $item->export_revenue, ['class' => 'form-control select2-show-search']) }}
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                {{ Form::label('total_capitalization', translateText('کل سرمایه', lang_admin()).'*') }} <span dir="ltr">(US$)</span>
                                {{ Form::select('total_capitalization', $total_capitalizations, $item->total_capitalization, ['class' => 'form-control select2-show-search']) }}
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                {{ Form::label('nearest_port', translateText('نزدیک‌ترین بندر', lang_admin()).'*') }}
                                {{ Form::select('nearest_port', $countries, $item->nearest_port, ['class' => 'form-control select2-show-search']) }}
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{ Form::label('export_percentage',translateText( 'درصد صادرات ',lang_admin())) }}
                                {{ Form::number('export_percentage', $item->export_percentage, ['class' => 'form-control']) }}
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group">
                                {{ Form::label('terms_of_trades', translateText('شرایط تجارت', lang_admin()).'*') }}
                                {{ Form::select('terms_of_trades[]', $trade_terms, json_decode($item->terms_of_trades,true), ['class' => 'form-control select2-show-search', 'multiple']) }}
                            </div>
                        </div>

                        <div class="col-md-12 text-left">
                            <hr>
                            {{ Form::submit(translateText('ویرایش', lang_admin()), ['class' => 'btn btn-primary', 'onclick' => "return confirm('".translateText('برای ارسال فرم مطمئن هستید؟', lang_admin())."')"]) }}
                        </div>
                    </div>
                    {{ Form::close() }}
                </div>
            </div>
        </div>
    </div>
@endsection