@extends('admin.layouts.app',['tbl'=>true])

@section('content')

    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="w-100">
                        {{$title}}
                    </h4>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table  table-vcenter text-nowrap table-bordered border-bottom" id="tbl_1">
                            <thead>
                            <tr>
                                <th class="border-bottom-0">#</th>
                                <th class="border-bottom-0">{{translateText('نام',lang_admin())}}</th>
                                <th class="border-bottom-0">{{translateText('اطلاعات تماس',lang_admin())}}</th>
                                <th class="border-bottom-0">{{translateText('تاریخ',lang_admin())}}</th>
                                <th class="border-bottom-0">{{translateText('متن',lang_admin())}}</th>
                                <th class="border-bottom-0">{{translateText('بررسی شد',lang_admin())}}</th>
                                <th class="border-bottom-0">{{translateText('زمان ثبت',lang_admin())}}</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($items as $key=>$item)
                                <tr class="{{$item->seen=='no'?'tr_seen':''}}">
                                    <td>{{$key+1}}</td>
                                    <td>
                                        {{translateText('نام(شرکت/کارخانه)',lang_admin())}}: {{$item->c_name}}
                                        <br/>
                                        {{translateText('نام/نام خانوادگی',lang_admin())}}: {{$item->f_name}} {{$item->l_name}}
                                    </td>
                                    <td dir="ltr">
                                        {{$item->email}}
                                        <br/>
                                        {{$item->phone}}
                                    </td>
                                    <td dir="ltr">
                                        {{$item->date_start}}
                                        <br/>
                                        {{$item->date_end}}
                                    </td>
                                    <td>
                                        <a tabindex="0" data-toggle="popover" data-trigger="focus" role="button" data-content="{{$item->text}}" data-original-title="{{translateText('Target Audience: ...',lang_admin())}}" class="popover_125 btn btn-sm btn-primary">{{translateText('کلیک کنید',lang_admin())}}
                                        </a>
                                    </td>
                                    <td>
                                        @if($item->status == 'pending')
                                            <a href="{{route('admin.form.sell.your.product.status',$item->id)}}" onclick="return confirm({{translateText('برای تغییر وضعیت به بررسی شد مطمئن هستید؟',lang_admin())}})" class="btn btn-success">
                                                {{translateText('بررسی شد',lang_admin())}}
                                            </a>
                                        @else
                                            <span class="text-success">{{translateText('بررسی شده در تاریخ: ',lang_admin())}}</span>
                                        <br/>
                                            <span dir="ltr">{{$item->date_status}}</span>
                                        @endif
                                    </td>
                                    <td>
                                        {{$item->created_at}}
                                    </td>
                                </tr>
                                {{$item->show_seen($item)}}
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>


@endsection

@section('scripts')
    <script>
        $(document).ready(function () {
            $('[data-toggle="popover"]').popover();
        });
        $('.popover-dismiss').popover({
            trigger: 'focus'
        })
    </script>
@endsection
