@extends('admin.layouts.app',['req'=>true,'editor'=>true,'file_upload'=>true])

@section('content')
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="card-title">
                        {{$title}}
                    </h4>
                </div>
                <hr>

                <div class="card-body">
                    {{ Form::open(array('route' => 'admin.gallery.store', 'method' => 'POST','id'=>'form_req','files'=>true)) }}
                    <div class="row">
{{--                          <nav class="w-100">--}}
{{--                            <div class="nav nav-tabs" id="nav-tab" role="tablist">--}}
{{--                                @foreach(tab_langs() as $lang)--}}
{{--                                    <button class="nav-link {{$lang->status=='default'?'active':''}}" id="nav-{{$lang->lang}}-tab" data-toggle="tab" data-target="#nav-{{$lang->lang}}" type="button" role="tab" aria-controls="nav-{{$lang->lang}}" aria-selected="false">{{$lang->lang}}</button>--}}
{{--                                @endforeach--}}
{{--                            </div>--}}
{{--                        </nav>--}}
                        <div class="tab-content w-100" id="nav-tabContent">
                            @foreach(tab_langs() as $lang)
                                <div class="tab-pane fade {{$lang->status=='default'?'show active':''}}  {{$lang->align=='ltr'?'ltr_tab':''}}" id="nav-{{$lang->lang}}" role="tabpanel" aria-labelledby="nav-{{$lang->lang}}-tab">
                                    <div class="container-fluid">
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'title':'title_'.$lang->lang, translateText('عنوان',lang_admin()))}}
                                                    {{Form::text($lang->status=='default'?'title':'title_'.$lang->lang, null, array('class' => 'form-control'))}}
                                                </div>
                                            </div>

                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'status':'status_'.$lang->lang, translateText('وضعیت',lang_admin()).' *')}}
                                                    {{ Form::select($lang->status=='default'?'status':'status_'.$lang->lang, ['pending'=>translateText('عدم انتشار',lang_admin()),'active'=>translateText('انتشار',lang_admin())], null, array('class' => 'form-control select2-show-search custom-select','required')) }}
                                                </div>
                                            </div>
                                        
                                            <div class="col-md-12 d-none">
                                                {{Form::label($lang->status=='default'?'text':'text_'.$lang->lang, translateText('متن',lang_admin()))}}
                                                <div class="form-group form-group-post">
                                                    {{Form::textarea($lang->status=='default'?'text':'text_'.$lang->lang, null, array('class' => 'form-control textarea_'.$lang->align))}}
                                                </div>
                                            </div>
                                         
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('photo', translateText('تصویر اصلی',lang_admin()).'* ')}}
                                {{Form::file('photo', array('class' => 'dropify','data-height'=>'180','accept' => '.jpg,.jpeg,.webp','required'))}}
                            </div>
                            <p class="text-danger">_<small>{{translateText('حداکثر حجم تصویر 512KB می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">_<small>{{translateText('بهترین سایز تصویر ارتفاع کمی کوچکتر از عرض می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">_<small>{{translateText('فرمت تصویر فقط باید JPG,JPEG,WEBP باشد',lang_admin())}}</small></p>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <div class="form-group">
                                    {{Form::label('photos',translateText('تصاویر',lang_admin()))}}
                                    <div class="input-group mb-5 file-browser">
                                        <input type="text" class="form-control browse-file" placeholder="{{translateText('تصاویر خود را انتخاب کنید',lang_admin())}}" readonly>
                                        <label class="input-group-append">
												<span class="btn btn-primary">
													{{translateText('انتخاب',lang_admin())}}
                                                    {{Form::file('photos[]', array('class' => 'file-browserinput d-none','accept' => '.jpg,.png,.jpeg,.webp','multiple'))}}
												</span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <p class="text-danger">_<small>{{translateText('حداکثر حجم تصویر 512KB می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">_<small>{{translateText('بهترین سایز تصویر ارتفاع کمی کوچکتر از عرض می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">_<small>{{translateText('فرمت تصویر فقط باید JPG,JPEG,WEBP,PNG باشد',lang_admin())}}</small></p>
                            <p class="text-danger">_<small>{{translateText('شما می توانید با نگه داشتن کلید ctrl کیبورد چندین تصویر را انتخاب کنید',lang_admin())}}</small></p>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <div class="form-group">
                                    {{Form::label('films', translateText('ویدئو',lang_admin()))}}
                                    <div class="input-group mb-5 file-browser">
                                        <input type="text" class="form-control browse-file" placeholder="{{translateText('ویدئو های خود را انتخاب کنید',lang_admin())}}" readonly>
                                        <label class="input-group-append">
												<span class="btn btn-primary">
													{{translateText('انتخاب',lang_admin())}}
                                                    {{Form::file('films[]', array('class' => 'file-browserinput d-none','accept' => '.mp4','multiple'))}}
												</span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <p class="text-danger">_<small>{{translateText('حداکثر حجم هر ویدئو 30Mb می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">_<small>{{translateText('فرمت ویدئو فقط باید  MP4 باشد',lang_admin())}}</small></p>
                            <p class="text-danger">_<small>{{translateText('شما می توانید با نگه داشتن کلید ctrl کیبورد چندین ویدئو را انتخاب کنید',lang_admin())}}</small></p>
                        </div>
                        <div class="col-md-12 text-left">
                            <hr/>
                            {{Form::submit(translateText('افزودن',lang_admin()),array('class'=>'btn btn-primary','onclick'=>"return confirm('".translateText('برای ارسال فرم مطمئن هستید؟',lang_admin())."')"))}}
                        </div>
                    </div>
                    {{ Form::close() }}
                </div>
            </div>
        </div>
    </div>
@endsection
