@extends('admin.layouts.app',['req'=>true,'editor'=>true,'file_upload'=>true])

@section('content')
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="card-title">
                        {{$title}}
                    </h4>
                </div>

                <div class="card-body">
                    {{ Form::model($item,array('route' => array('admin.gallery.update',$item->id), 'method' => 'PATCH','files'=>true)) }}
                    {{Form::hidden('id', $item->id)}}
                    <div class="row">
{{--                         <nav class="w-100">--}}
{{--                            <div class="nav nav-tabs" id="nav-tab" role="tablist">--}}
{{--                                @foreach(tab_langs() as $lang)--}}
{{--                                    <button class="nav-link {{$lang->status=='default'?'active':''}} " id="nav-{{$lang->lang}}-tab" data-toggle="tab" data-target="#nav-{{$lang->lang}}" type="button" role="tab" aria-controls="nav-{{$lang->lang}}" aria-selected="false">{{$lang->lang}}</button>--}}
{{--                                @endforeach--}}
{{--                            </div>--}}
{{--                        </nav>--}}
                        <div class="tab-content w-100" id="nav-tabContent">
                            @foreach(tab_langs() as $lang)
                                <div class="tab-pane fade {{$lang->status=='default'?'show active':''}}  {{$lang->align=='ltr'?'ltr_tab':''}}" id="nav-{{$lang->lang}}" role="tabpanel" aria-labelledby="nav-{{$lang->lang}}-tab">
                                    <div class="container-fluid">
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'title':'title_'.$lang->lang, translateText('عنوان',lang_admin()))}}
                                                    {{Form::text($lang->status=='default'?'title':'title_'.$lang->lang, read_lang($item,'title',$lang->lang), array('class' => 'form-control'))}}
                                                </div>
                                            </div>

                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'status':'status_'.$lang->lang, translateText('وضعیت',lang_admin()).' *')}}
                                                    {{ Form::select($lang->status=='default'?'status':'status_'.$lang->lang, ['pending'=>translateText('عدم انتشار',lang_admin()),'active'=>translateText('انتشار',lang_admin())], read_lang($item,'status',$lang->lang), array('class' => 'form-control select2-show-search custom-select','required')) }}
                                                </div>
                                            </div>
                                            <div class="col-md-12 d-none">
                                                {{Form::label($lang->status=='default'?'text':'text_'.$lang->lang, translateText('متن',lang_admin()))}}
                                                <div class="form-group form-group-post">
                                                    {{Form::textarea($lang->status=='default'?'text':'text_'.$lang->lang, read_lang($item,'text',$lang->lang), array('class' => 'form-control textarea_'.$lang->align))}}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                {{Form::label('photo', translateText('تصویر اصلی',lang_admin()))}}
                                {{Form::file('photo', array('class' => 'dropify','data-height'=>'180','accept' => '.jpg,.jpeg,.webp','id' => $item->photo ? $item->photo->id : 0,'data-default-file'=>$item->photo && is_file($item->photo->path)?url($item->photo->path):null))}}
                            </div>
                            <p class="text-danger">_<small>{{translateText('حداکثر حجم تصویر 512KB می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">_<small>{{translateText('بهترین سایز تصویر ارتفاع کمی کوچکتر از عرض می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">_<small>{{translateText('فرمت تصویر فقط باید JPG,JPEG,WEBP باشد',lang_admin())}}</small></p>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <div class="form-group">
                                    {{Form::label('photos', translateText('تصاویر',lang_admin()))}}
                                    <div class="input-group mb-5 file-browser">
                                        <input type="text" class="form-control browse-file" placeholder="{{translateText('تصاویر خود را جهت آپلود انتخاب کنید',lang_admin())}}" readonly>
                                        <label class="input-group-append">
												<span class="btn btn-primary">
													{{translateText('انتخاب',lang_admin())}}
                                                    {{Form::file('photos[]', array('class' => 'file-browserinput d-none','accept' => '.jpg,.png,.jpeg,.webp','multiple'))}}
												</span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <p class="text-danger">_<small>{{translateText('حداکثر حجم تصویر 512KB می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">_<small>{{translateText('بهترین سایز تصویر ارتفاع کمی کوچکتر از عرض می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">_<small>{{translateText('فرمت تصویر فقط باید JPG,JPEG,WEBP,PNG باشد',lang_admin())}}</small></p>
                            <p class="text-danger">_<small>{{translateText('شما می توانید با نگه داشتن کلید ctrl کیبورد چندین تصویر را انتخاب کنید',lang_admin())}}</small></p>
                        </div>
                        @if(count($item->gallery_p))
                            <div class="col-md-12">
                                <div class="container-fluid">
                                    <div class="row">
                                        @foreach($item->gallery_p as $photo)
                                            <div class="col-md-3 col-sm-6">
                                                <div class="img_box_photos">
                                                    <img src="{{url($photo->file)}}" alt="{{$item->title}}">
                                                    <a href="{{route('admin.gallery.delete',$photo->id)}}"
                                                       onclick="return confirm('{{translateText('برای حذف مطمئن هستید؟',lang_admin())}}')"
                                                       class="photo_destroy file_delete" data-toggle="tooltip" data-placement="top"
                                                       title="{{translateText('حذف',lang_admin())}}">×</a>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        @endif
                        <div class="col-md-12">
                            <div class="form-group">
                                <div class="form-group">
                                    {{Form::label('films', translateText('ویدئو',lang_admin()))}}
                                    <div class="input-group mb-5 file-browser">
                                        <input type="text" class="form-control browse-file" placeholder="{{translateText('ویدئوهای خود  را جهت آپلود انتخاب کنید',lang_admin())}}" readonly>
                                        <label class="input-group-append">
												<span class="btn btn-primary">
													{{translateText('انتخاب',lang_admin())}}
                                                    {{Form::file('films[]', array('class' => 'file-browserinput d-none','accept' => '.mp4','multiple'))}}
												</span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <p class="text-danger">_<small>{{translateText('حداکثر حجم هر ویدئو 30Mb می باشد',lang_admin())}}</small></p>
                            <p class="text-danger">_<small>{{translateText('فرمت ویدئو فقط باید  MP4 باشد',lang_admin())}}</small></p>
                            <p class="text-danger">_<small>{{translateText('شما می توانید با نگه داشتن کلید ctrl کیبورد چندین ویدئو را انتخاب کنید',lang_admin())}}</small></p>
                        </div>
                        @if(count($item->gallery_v))
                                <div class="col-md-12">
                                    <div class="container-fluid">
                                        <div class="row">
                                            @foreach($item->gallery_v as $key=>$film)
                                                <div class="col-md-3 col-sm-6">
                                                    <div class="doc_box_documents">
                                                        <a href="{{url($film->file)}}"
                                                           target="_blank">
                                                            {{translateText('ویدئو',lang_admin())}}: {{$key+1}}
                                                        </a>
                                                        <a href="{{route('admin.gallery.delete',$film->id)}}"
                                                           onclick="return confirm('{{translateText('برای حذف مطمئن هستید؟',lang_admin())}}')"
                                                           class="document_destroy file_delete" data-toggle="tooltip"
                                                           data-placement="top" title="{{translateText('حذف',lang_admin())}}">×</a>
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                        @endif
                        <div class="col-md-12 text-left">
                            <hr/>
                            {{Form::submit(translateText('ویرایش',lang_admin()),array('class'=>'btn btn-primary','onclick'=>"return confirm('".translateText('برای ارسال فرم مطمئن هستید؟',lang_admin())."')"))}}
                        </div>
                    </div>
                    {{Form::close()}}
                </div>
            </div>
        </div>
    </div>


@endsection
