@extends('admin.layouts.app',['req'=>true,'editor'=>true,'file_upload'=>true])

@section('content')
    <div class="row mt-5">
        <div class="col-xl-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header  border-0">
                    <h4 class="card-title">
                        {{$title}}
                    </h4>
                </div>
                <hr>

                <div class="card-body">
                    @if(blank($l_id))
                    {{ Form::open(array('route' => 'admin.land.store', 'method' => 'POST','id'=>'form_req','files'=>true)) }}
                    {{Form::hidden('type', 'landing')}}
                    <div class="row">
                        <nav class="w-100">
                            <div class="nav nav-tabs" id="nav-tab" role="tablist">
                                @foreach(tab_langs() as $lang)
                                    <button class="nav-link {{$lang->status=='default'?'active':''}}" id="nav-{{$lang->lang}}-tab" data-toggle="tab"
                                            data-target="#nav-{{$lang->lang}}" type="button" role="tab"
                                            aria-controls="nav-{{$lang->lang}}"
                                            aria-selected="false">{{$lang->lang}}</button>
                                @endforeach
                            </div>
                        </nav>
                        <div class="tab-content w-100" id="nav-tabContent">
                            @foreach(tab_langs() as $lang)
                                <div class="tab-pane fade {{$lang->status=='default'?'show active':''}} {{$lang->align=='ltr'?'ltr_tab':''}}"
                                     id="nav-{{$lang->lang}}" role="tabpanel"
                                     aria-labelledby="nav-{{$lang->lang}}-tab">
                                    <div class="container-fluid">
                                        <div class="row">
                                            <div class="col-md-8">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'title':'title_'.$lang->lang, translateText('عنوان',lang_admin()))}}
                                                    {{Form::text($lang->status=='default'?'title':'title_'.$lang->lang, null, array('class' => 'form-control'))}}
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'status':'status_'.$lang->lang, translateText('وضعیت',lang_admin()). ' *')}}
                                                    {{ Form::select($lang->status=='default'?'status':'status_'.$lang->lang, ['pending'=>translateText('عدم انتشار',lang_admin()),'active'=>translateText('انتشار',lang_admin())], null, array('class' => 'form-control select2-show-search','required')) }}
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    {{Form::label($lang->status=='default'?'title_footer':'title_footer_'.$lang->lang, translateText('عنوان در منو',lang_admin()))}}
                                                    {{Form::text($lang->status=='default'?'title_footer':'title_footer_'.$lang->lang, null, array('class' => 'form-control'))}}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                {{Form::label('slug', '* Slug')}}
                                {{Form::text('slug', null, array('class' => 'form-control slug_input','required'))}}
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                {{Form::label('footer', translateText('نمایش در منو؟',lang_admin()).' *')}}
                                {{ Form::select('footer', ['supplier'=>'Supplier','buyer'=>'Buyer','no'=>'NO'], null, array('class' => 'form-control select2-show-search','required')) }}
                            </div>
                        </div>
                        <div class="col-md-12 text-left">
                            <hr/>
                            {{Form::submit(translateText('افزودن',lang_admin()),array('class'=>'btn btn-primary','onclick'=>"return confirm('".translateText('برای ارسال فرم مطمئن هستید؟',lang_admin())."')"))}}
                        </div>
                    </div>
                    {{ Form::close() }}
                    @else
                        {{ Form::open(array('route' => ['admin.land.store',['l_id'=>$l_id]], 'method' => 'POST','id'=>'form_req','files'=>true)) }}
                        {{Form::hidden('type', 'landing_d')}}
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    {{Form::label('title', translateText('عنوان',lang_admin()))}}
                                    {{Form::text('title', null, array('class' => 'form-control'))}}
                                </div>
                            </div>
                            <nav class="w-100">
                                <div class="nav nav-tabs" id="nav-tab" role="tablist">
                                    @foreach(tab_langs() as $lang)
                                        <button class="nav-link {{$lang->status=='default'?'active':''}}" id="nav-{{$lang->lang}}-tab" data-toggle="tab"
                                                data-target="#nav-{{$lang->lang}}" type="button" role="tab"
                                                aria-controls="nav-{{$lang->lang}}"
                                                aria-selected="false">{{$lang->lang}}</button>
                                    @endforeach
                                </div>
                            </nav>
                            <div class="tab-content w-100" id="nav-tabContent">
                                @foreach(tab_langs() as $lang)
                                    <div class="tab-pane fade {{$lang->status=='default'?'show active':''}} {{$lang->align=='ltr'?'ltr_tab':''}}"
                                         id="nav-{{$lang->lang}}" role="tabpanel"
                                         aria-labelledby="nav-{{$lang->lang}}-tab">
                                        <div class="container-fluid">
                                            <div class="row">

                                                <div class="col-md-4">
                                                    <div class="form-group">
                                                        {{Form::label($lang->status=='default'?'status':'status_'.$lang->lang, translateText('وضعیت',lang_admin()).' *')}}
                                                        {{ Form::select($lang->status=='default'?'status':'status_'.$lang->lang, ['pending'=>translateText('عدم انتشار',lang_admin()),'active'=>translateText('انتشار',lang_admin())], null, array('class' => 'form-control select2-show-search','required')) }}
                                                    </div>
                                                </div>
                                                <div class="col-md-12">
                                                    {{Form::label($lang->status=='default'?'text':'text_'.$lang->lang, translateText('متن',lang_admin()))}}
                                                    <div class="form-group form-group-post">
                                                        {{Form::textarea($lang->status=='default'?'text':'text_'.$lang->lang, null, array('class' => 'form-control textarea_'.$lang->align))}}
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    {{Form::label('width', translateText('عرض نمایش',lang_admin()).' *')}}
                                    {{ Form::select('width', ['100'=>'100%','75'=>'75%','50'=>'50%','33'=>'33%','25'=>'25%'], null, array('class' => 'form-control select2-show-search','required')) }}
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    {{Form::label('v_h', translateText('عمودی/افقی(متن و تصویر با هم)',lang_admin()).' *')}}
                                    {{ Form::select('v_h', ['v'=>'Vertical','h'=>'Horizental'], null, array('class' => 'form-control select2-show-search','required')) }}
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    {{Form::label('sort', translateText('Sort',lang_admin()))}}
                                    {{Form::number('sort', 0, array('class' => 'form-control'))}}
                                </div>
                            </div>
                            <div class="col-md-8">
                                <div class="form-group">
                                    {{Form::label('photo', translateText('تصویر',lang_admin()))}}
                                    {{Form::file('photo', array('class' => 'dropify','data-height'=>'180','accept' => '.jpg,.jpeg,.webp'))}}
                                </div>
                                <p class="text-danger">_<small>{{translateText('حداکثر حجم تصویر 512KB می باشد',lang_admin())}}</small></p>
                                <p class="text-danger">_<small>{{translateText('فرمت تصویر فقط باید JPG,JPEG,WEBP باشد',lang_admin())}}</small></p>
                            </div>
                            <div class="col-md-12 text-left">
                                <hr/>
                                {{Form::submit(translateText('افزودن',lang_admin()),array('class'=>'btn btn-primary','onclick'=>"return confirm('".translateText('برای ارسال فرم مطمئن هستید؟',lang_admin())."')"))}}
                            </div>
                        </div>
                        {{ Form::close() }}
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection


