<script>
    $(".key_word").selectize({
        delimiter: ",,",
        plugins: {
            remove_button: {
                label: "×"
            }
        },
        persist: false,
        createOnBlur: true,
        create: true
    });
    $(".contact_multi").selectize({
        delimiter: ",",
        plugins: {
            remove_button: {
                label: "×"
            }
        },
        persist: false,
        createOnBlur: true,
        create: true,
        copyClassesToDropdown: false
    });
    @if(isset($req))
    $(document).ready(function () {
        jQuery.extend(jQuery.validator.messages, {
            required: "{{translateText('این فیلد الزامی است.',lang_admin())}}",
            remote: "{{translateText('لطفاً این قسمت را اصلاح کنید.',lang_admin())}}",
            email: "{{translateText('لطفا یک آدرس ایمیل معتبر وارد کنید.',lang_admin())}}",
            url: "{{translateText('لطفا یک نشانی وب معتبر وارد کنید.',lang_admin())}}",
            date: "{{translateText('لطفا یک تاریخ معتبر وارد کنید.',lang_admin())}}",
            dateISO: "{{translateText('لطفاً تاریخ معتبر (ISO) را وارد کنید.',lang_admin())}}",
            number: "{{translateText('لطفا یک شماره معتبر وارد کنید.',lang_admin())}}",
            digits: "{{translateText('لطفاً فقط ارقام را وارد کنید.',lang_admin())}}",
            creditcard: "{{translateText('لطفا یک شماره کارت اعتباری معتبر وارد کنید.',lang_admin())}}",
            equalTo: "{{translateText('لطفا مجددا همان مقدار را وارد کنید.',lang_admin())}}",
            accept: "{{translateText('لطفاً یک مقدار با پسوند معتبر وارد کنید.',lang_admin())}}",
            maxlength: jQuery.validator.format("{{translateText('لطفاً بیش از {0} نویسه وارد نکنید.',lang_admin())}}"),
            minlength: jQuery.validator.format("{{translateText('لطفاً حداقل {0} نویسه وارد کنید.',lang_admin())}}"),
            rangelength: jQuery.validator.format("{{translateText('لطفاً مقدار بین {0} و {1} نویسه را وارد کنید.',lang_admin())}}"),
            range: jQuery.validator.format("{{translateText('لطفاً مقداری بین {0} و {1} وارد کنید.',lang_admin())}}"),
            max: jQuery.validator.format("{{translateText('لطفاً مقداری کمتر یا مساوی {0} وارد کنید.',lang_admin())}}"),
            min: jQuery.validator.format("{{translateText('لطفاً مقدار بزرگتر یا مساوی {0} وارد کنید.',lang_admin())}}")
        });

    });

    $("#form_req").validate({
        submitHandler: function (form) {
            if ($('.textarea_rtl')[0] || $('.textarea_ltr')[0]) {
                for (var i in CKEDITOR.instances) {
                    CKEDITOR.instances[i].updateElement();
                }
            }

            $('#global-loader-form').css('display', 'block');
            form.submit();
        }
    });
    @endif
    @if(session()->has('err_message'))
    $(document).ready(function () {
        Swal.fire({
            title: "{{translateText('ناموفق',lang_admin())}}",
            text: "{{ session('err_message') }}",
            icon: "warning",
            timer: 6000,
            timerProgressBar: true,
        })
    });
    @endif
    @if(session()->has('flash_message'))
    $(document).ready(function () {
        Swal.fire({
            title: "{{translateText('موفق',lang_admin())}}",
            text: "{{ session('flash_message') }}",
            icon: "success",
            timer: 6000,
            timerProgressBar: true,
        })
    })
    ;@endif
    @if (count($errors) > 0)
    $(document).ready(function () {
        Swal.fire({
            title: "{{translateText('ناموفق',lang_admin())}}",
            icon: "warning",
            html:
                    @foreach ($errors->all() as $key => $error)
                        '<p class="text-right mt-2 ml-5" dir="rtl"> {{$key+1}} : ' +
                '{{ $error }}' +
                '</p>' +
                    @endforeach
                        '<p class="text-right mt-2 ml-5" dir="rtl">' +
                '</p>',
            timer: @if(count($errors)>3)parseInt('{{count($errors)}}') * 1500 @else 6000 @endif,
            timerProgressBar: true,
        })
    });
    @endif

    $(".dropify-clear").on('click', function () {

        var dropifyInput = $(this).closest('.dropify-wrapper').find('.dropify');
        var photo_id = dropifyInput.attr('id');
        
        var data = {
            photo_id: photo_id
        }
        $.ajax({
            type: "get",
            url: "{{route('admin.setting.delete.photo')}}",
            data: data,
            dataType: "json",
            success: function (response) {
                if (response.status === 'success') {
                    Swal.fire({
                        title: "{{translateText('موفق',lang_admin())}}",
                        text: "{{translateText('اطلاعات با موفقیت حذف شد.',lang_admin())}}",
                        icon: "success",
                        timer: 6000,
                        timerProgressBar: true,
                    })
                } else {
                    Swal.fire({
                        title: "{{translateText('ناموفق',lang_admin())}}",
                        text: "{{translateText('برای حذف به مشکل خوردیم، مجددا تلاش کنید.',lang_admin())}}",
                        icon: "warning",
                        timer: 6000,
                        timerProgressBar: true,
                    })
                }
            }
        });
    })
</script>
<script src="{{URL::asset('assets/admin/js/custom.js?v=1.1.1')}}"></script>